<?php

$tradematikUrl = 'http://tradematik.pl';

$wordpressUrl = 'http://wordpress.org';

if ( ! isset( $content_width ) ) $content_width = 700;



if (function_exists('get_meta_box')) {
    include_once('inc/metabox.php');
}

include_once('inc/ajax.php');
include_once('inc/slider.php');
include_once('inc/class.bootstrap.navmenu.php');

include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); 

add_theme_support( 'post-thumbnails', array('post', 'page', 'produkty') ); 

add_theme_support( 'automatic-feed-links' );

$headerargs = array(
    'width'         => 168,
    'height'        => 50
);
add_theme_support( 'custom-header', $headerargs );

$bgdefaults = array(
    'default-color'          => '',
    'default-image'          => '',
    'wp-head-callback'       => '_custom_background_cb',
    'admin-head-callback'    => '',
    'admin-preview-callback' => ''
);
add_theme_support( 'custom-background', $bgdefaults );


add_image_size('slider', 940, 500, true);

add_image_size('archive', 220, 136, true);

add_image_size('produkt', 460, 300, false);

add_image_size('produkt-thumb', 60, 50, true);

load_theme_textdomain('tradematik-theme', get_template_directory());


 // dodanie widgetow w stopce
    $wargs = array(
            'name'          => __( 'Boxes in footer', 'tradematik-theme' ),
            'id'            => 'footer-widgets',
            'description'   => '',
            'class'         => '',
            'before_widget' => '<div class="span3 widget %2$s">',
            'after_widget'  => '</div></div>',
            'before_title'  => '<h5 class="widgettitle">',
            'after_title'   => '</h5><div class="widgetContent">' );

    register_sidebar( $wargs );

    // dodanie widgetow w panelu bocznym
    $sargs = array(
            'name'          => __( 'Widgets in sidebar', 'tradematik-theme' ),
            'id'            => 'sidebar-widgets',
            'description'   => '',
            'class'         => '',
            'before_widget' => '<div class="widget %2$s">',
            'after_widget'  => '</div></div>',
            'before_title'  => '<h4 class="widgettitle">',
            'after_title'   => '</h4><div class="widgetContent">' );

    register_sidebar( $sargs );

register_nav_menu( 'top-menu', __('Top Menu', 'tradematik-theme') );

/**
 * Enqueue plugin style-file
 */
add_action( 'wp_enqueue_scripts', 'tradetheme_enqueue' );

function tradetheme_enqueue() {
    wp_enqueue_script('jquery-ui-tabs'); 

    wp_enqueue_script( 'tradetheme-bootstrap-transition', get_template_directory_uri() . '/assets/js/bootstrap-transition.js'  );   

    wp_enqueue_script( 'tradetheme-bootstrap-carousel', get_template_directory_uri() . '/assets/js/bootstrap-carousel.js'  );   

    wp_enqueue_script( 'tradetheme-bootstrap-tab', get_template_directory_uri() . '/assets/js/bootstrap-tab.js'  );   

    wp_enqueue_script( 'tradetheme-bootstrap-dropdown', get_template_directory_uri() . '/assets/js/bootstrap-dropdown.js'  );  

    wp_enqueue_script( 'tradetheme-bootstrap-alert', get_template_directory_uri() . '/assets/js/bootstrap-alert.js'  );

    wp_enqueue_script( 'tradetheme-jqueryform', get_template_directory_uri() . '/assets/js/jquery.form.js'  );

    if ( is_singular() ) wp_enqueue_script( "comment-reply" );

    wp_enqueue_script( 'tradetheme-tradematik', get_template_directory_uri() . '/assets/js/tradematik.js'  );   



    wp_enqueue_script('thickbox',null,array('jquery'));
    wp_enqueue_style('thickbox.css', '/'.WPINC.'/js/thickbox/thickbox.css', null, '1.0');

    // zakomentuj ponizsze jesli chcesz by to less decydowal o wygladzie strony
    // odkomentuj wtedy odpowiedni fragment w header.php
    wp_enqueue_style('style.yui.css', get_template_directory_uri() . '/assets/less/style.yui.css', null, '1.0');


}

add_action('init', 'tradetheme_custom_types');
function tradetheme_custom_types() {


 register_post_type('produkty',
  array(
   'labels' => array(
    'name' => __('Products', 'tradematik-theme'),
    'singular_name' => __('Product', 'tradematik-theme'),
    'add_new' => __('Add product', 'tradematik-theme') ,
    'add_new_item' => __('Add new product', 'tradematik-theme')
   ),
   'public' => true,
   'has_archive' => true
  )
 );
 
 add_post_type_support('produkty', 'revisions');
 add_post_type_support('produkty', 'page-attributes');
 add_post_type_support('produkty', 'comments');
 add_post_type_support('produkty', 'excerpt');
 add_post_type_support('produkty', 'thumbnail');
 add_post_type_support('produkty', 'custom-fields');
 
 register_taxonomy('kategoria-produktu', 'produkty',
  array(
   'hierarchical' => true,
   'labels' => array(
    'name' => __('Categories of products', 'tradematik-theme') ,
    'singular_name' => __('Category of products', 'tradematik-theme') , 
    
   )
  )  
 );

 }



function dodaj_produkty_do_loop($query) {
    if ( ( is_home() or is_archive() or is_tag() or is_feed() ) and $query->is_main_query() ) {
        $query->set('post_type', array('produkty'));
    }

    if ( is_search() ) {
        $query->set('post_type', array('produkty', 'post', 'page'));
    }

    
    
    return $query;
}

add_action('pre_get_posts', 'dodaj_produkty_do_loop');

function trade_default_image($post_id, $size, $dimensions, $class) {
global $post;

    if (!isset($dimmensions)) {
        $dimmensions = array('', '');
    }

    if (has_post_thumbnail()) {
        $kodObr = get_the_post_thumbnail($post_id, $size, array('class' => $class));
    }

    else {
        $obrazki = get_posts(array(
                    'numberposts' => 1,
                    'post_parent' => $post_id,
                    'post_type' => 'attachment',
                    'post_mime_type' => 'image',
                    'order' => 'ASC',
                    'orderby' => 'menu_order ID'
                ));

        if (!empty($obrazki)) {
            foreach ($obrazki as $obrazek) {
                $img = wp_get_attachment_image_src( $obrazek->ID, $size);
            }

            $kodObr = '<img src="'.$img[0].'" class="'.$class.'" 
                         width="'.$img[1].'" height="'.$img[2].'">';
        }

        else {
            $kodObr = '<img src="'.get_bloginfo('stylesheet_directory').'/assets/img/def-image-'.$size.'.png" 
                        class="'.$class.'" 
                        width="'.$dimmensions[0].'" height="'.$dimmensions[0].'">';
        }

        
    }

    return $kodObr;
}
