<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <title><?php bloginfo('name'); ?> <?php wp_title("",true); ?></title>
    <meta charset="utf-8">
    <!-- odkomentuj ponizsze linie, jesli chcesz aby to less decydowal o stylach strony, zakomentuj wtedy odwolanie do 
    style.yui.css w functions.php -->
    <!-- <link rel="stylesheet/less" type="text/css" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/less/bootstrap.less"> 
    <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/less.js" type="text/javascript"></script> -->

    <link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>">

    <?php 
    global $tradematikUrl;
    wp_head(); ?>

</head>
<body <?php body_class(); ?>>
<div class="container">

    <div class="navbar">
        <div class="navbar-inner">
            <a class="brand" href="<?php echo home_url(); ?>">
                <?php if (get_header_image() == '') : ?>
                    <?php bloginfo('name') ?>
                <?php else : ?>
                    <img src="<?php header_image(); ?>" height="<?php echo get_custom_header()->height; ?>" 
                        width="<?php echo get_custom_header()->width; ?>" alt="">
                <?php endif; ?>
            </a>

            <?php wp_nav_menu( array( 'theme_location' => 'top-menu',
                                      'items_wrap' => '<ul class="nav">%3$s</ul>',
                                      'walker' => new Bootstrap_Walker_Nav_Menu() ) ); ?>

            

                <form class="navbar-search pull-right" role="search" method="get" id="searchform" action="<?php echo home_url( '/' ); ?>">
                    <input type="text" class="search-query" placeholder="<?php _e('Search', 'tradematik-theme') ?>"  name="s" id="search" value="<?php the_search_query(); ?>">
                </form>

        </div>
    </div>

    <?php 
    if (!is_plugin_active('tradematik/tradematik.php')) :
    ?>

    <div class="alert">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong><?php _e('Warning!', 'tradematik-theme'); ?></strong> 
        <?php _e('Before use this theme, you should install and activate ', 'tradematik-theme'); ?>
        <a href="<?php echo $tradematikUrl; ?>" target="_blank">TradeMatik</a>
        <?php _e('plugin. (Or you can try to make some changes in this template\'s source code to fit this to other e-commerce solutions.)', 'tradematik-theme'); ?>
    </div>
    <?php 
    endif; 

    if (get_option('trade_opt_product_box_display') != '3') :
    ?>

    <div class="alert">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong><?php _e('Warning!', 'tradematik-theme'); ?></strong> 
        <?php _e('Go to Tradematik &raquo; Product configuration and set "Display product box" to "Dont display. I will add shortcode or template tag manually"', 'tradematik-theme'); ?>
    </div>
    <?php endif; ?>