<?php get_header(); ?>

<?php if (!is_paged()) : ?>

<?php get_template_part('part', 'slider'); ?>

<?php endif; ?>


    <div class="row">

        
        <div class="span9 pull-right">

            <?php if (have_posts()) : ?>

            <!-- product-grid -->
            
            <?php if (is_category()) : ?>

            <h3><?php printf( __( 'Products in category: %s', 'tradematik-theme' ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?></h3>

            <?php elseif (is_search()) : ?>

            <h3><?php _e( 'Search results for:', 'tradematik-theme' ); ?> <?php the_search_query(); ?></h3>

            <?php else : ?>

            <h3><?php _e('Recommended', 'tradematik-theme'); ?></h3>

            <?php endif; ?>

            <ul class="thumbnails product-grid">

                <?php while (have_posts()) : the_post(); 
                $price = false;
                $price = get_post_meta($post->ID, 'attr_price', true);

                $kodObr = trade_default_image($post->ID, 'archive', array('220', '136'), 'img-rounded');

                

                ?>

                <li class="span3">
                    <div class="thumbnail">
                        <a href="<?php the_permalink(); ?>">
                            <?php echo $kodObr; ?>
                        </a>
                        <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                        <div class="product-desc excerpt">
                            <?php the_excerpt(); ?>
                        </div>

                        <form class="the_trade_box_form" action="<?php echo get_permalink(get_option('trade_opt_cart_page')); ?>" method="post">
                            <input type="hidden" value="<?php the_ID(); ?>" name="trade_item_id">
                            <button type="submit" class="btn btn-success" name="trade_add_to_cart" title="<?php _e('Add to cart', 'tradematik-theme'); ?>">
                                <i class="icon-shopping-cart icon-white"></i> <?php echo $price; ?> <?php echo get_option('trade_opt_dotpay_currency'); ?>
                            </button> 
                        </form>
                        <a class="btn btn-mini" href="<?php the_permalink(); ?>" title="<?php _e('See details', 'tradematik-theme'); ?>"><?php _e('More...', 'tradematik-theme'); ?></a>
                    </div>
                </li>

                <?php endwhile; ?>

                <div class="postNavLink">
                <?php posts_nav_link(); ?>
                </div>

                
            </ul>

            <!-- product-grid end -->

            <?php endif; // have_posts ?>




        </div>

        <?php get_sidebar(); ?>

    </div>
<?php get_footer(); ?>