<?php
if ( ! function_exists( 'tradetheme_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since Shape 1.0
 */
function tradetheme_comment( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    ?>

    <div class="comment">
	    <p class="lead"><strong class="label label-info"><?php _e('Name', 'tradematik-theme'); ?>:</strong> <?php comment_author(); ?></p>
	    <div class="">
	        <span class="label label-success"><?php _e('Content', 'tradematik-theme'); ?>:</span> 
	        <?php comment_text(); ?>
	    </div>
	    <p><span class="label label-warning"><?php _e('Date', 'tradematik-theme'); ?>:</span> <?php comment_time('j-n-Y') ?></p>
	    <hr>
	</div>
 
    <?php
}
endif; // ends check for shape_comment()


/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments
 * and the comment form. The actual display of comments is
 * handled by a callback to shape_comment() which is
 * located in the inc/template-tags.php file.
 *
 * @package Shape
 * @since Shape 1.0
 */
?>
 
<?php
    /*
     * If the current post is protected by a password and
     * the visitor has not yet entered the password we will
     * return early without loading the comments.
     */
    if ( post_password_required() )
        return;
?>
 
    <div id="comments" class="comments-area">
 
    <?php // You can start editing here -- including this comment! ?>
 
    <?php if ( have_comments() ) : ?>
        <div>
            <legend><?php _e('Customers reviews', 'tradematik-theme'); ?></legend>
            <?php
                /* Loop through and list the comments. Tell wp_list_comments()
                 * to use shape_comment() to format the comments.
                 * If you want to overload this in a child theme then you can
                 * define shape_comment() and that will be used instead.
                 * See shape_comment() in inc/template-tags.php for more.
                 */
                wp_list_comments( array( 'callback' => 'tradetheme_comment' ) );
            ?>
        </div>
 
    <?php endif; // have_comments() 
    paginate_comments_links();

    ?>


 
    <?php
        // If comments are closed and there are comments, let's leave a little note, shall we?
        if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
    ?>
        <p class="nocomments"><?php _e( 'Comments are closed.', 'tradematik-theme' ); ?></p>
    <?php endif; ?>
 
    
 
</div><!-- #comments .comments-area -->

<?php 

// $comFormArgs = array(

// 	);

// comment_form($comFormArgs); ?>