<?php 
/*
Template Name: Blog Posts
*/
?>

<?php get_header(); ?>

    <div class="row">

        
        <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <div class="span9 pull-right">

                <?php 
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                query_posts('post_type=post&paged=' . $paged); ?>

                <?php if (have_posts()) : ?>

                <?php while (have_posts()) : the_post(); ?>

                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                
                <?php the_excerpt(); ?>

                <div class="alert alert-info">
                    <?php the_tags(); ?> <?php the_date(false, __('Published: ', 'tradematik-theme')); ?>
                </div> 
                

                <?php endwhile; ?>

                <div class="postNavLink">
                <?php posts_nav_link(); ?>
                </div>

                <?php endif; // have_posts ?>

                <?php wp_reset_query(); ?>




            </div>

        </div>

        <?php get_sidebar(); ?>

    </div>
<?php get_footer(); ?>