<?php 
 // dodaj metabox do typu 'produkty'
 add_action( 'add_meta_boxes', 'tradetheme_product_box_add', 100 );

 add_action( 'save_post', 'tradetheme_product_box_save' );

 function tradetheme_product_box_add() {
  if (function_exists('get_meta_box')) {
    $meta_box_tradematik=get_meta_box();

    add_meta_box($meta_box_tradematik['id'], $meta_box_tradematik['title'], 'tradetheme_product_box', 'produkty', $meta_box_tradematik['context'], $meta_box_tradematik['priority']);
  }
 }

 function tradetheme_product_box( $post ) {
  global  $post;

  if (!function_exists('get_meta_box')) return;

  $meta_box_tradematik=get_meta_box();

  $meta_box_tradematik['fields'][] = array(
      'name' =>  __('Item specification', 'tradematik-theme'),
      'desc' => __('Not required', 'tradematik-theme'),
      'id' => 'attr_spec',
      'type' => 'textarea',
      'std' => '',
      'help' => __('Each parameter insert in new line. After name of parameter type colon and then value of this parameter.', 'tradematik-theme')
    );
  
  //wp_nonce_field( plugin_basename( __FILE__ ), 'tradematik_noncename' );
  echo '<input type="hidden" name="tradematik" value="', wp_create_nonce(basename(__FILE__)), '" />';
  
  echo '<table class="form-table">';
 
  foreach ($meta_box_tradematik['fields'] as $field) {
    $meta = get_post_meta($post->ID, $field['id'], true);
    switch ($field['type']) {
      case 'text':      
      echo '<tr style="border-top:1px solid #eeeeee;">',
        '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">'. @$field['desc'].'</span></label></th>',
        '<td>';
      echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', isset($meta) ? $meta : stripslashes(htmlspecialchars(( $field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                        if (!empty($field['help'])) echo "<div class='tr-metabox-help' style='clear: both;'>" . $field['help'] . "</div>";
      break;

      case 'textarea':      
      echo '<tr style="border-top:1px solid #eeeeee;">',
        '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">'. @$field['desc'].'</span></label></th>',
        '<td>';
      echo '<textarea name="', $field['id'], '" id="', $field['id'], '" style="width:75%; margin-right: 20px; float:left;">', isset($meta) ? $meta : stripslashes(htmlspecialchars(( $field['std']), ENT_QUOTES)), '</textarea>';
                        if (!empty($field['help'])) echo "<div class='tr-metabox-help' style='clear: both;'>" . $field['help'] . "</div>";
      break;


// http://austinpassy.com/snippets/wordpress/creating-custom-metaboxes-and-the-built-in-uploader/
      case 'file':      
      echo '<tr style="border-top:1px solid #eeeeee;">',
        '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">'. @$field['desc'].'</span></label></th>',
        '<td>';
      echo '<input type="button" name="costam" value="' . __('Choose file', 'tradematik') . '" id="trade_button_choose_img">
      
<script>
jQuery(document).ready(function() {

  var formfield;

  jQuery(\'#trade_button_choose_img\').click(function() {
    jQuery(\'html\').addClass(\'Image\');
    formfield = jQuery(\'#' . $field['id'] . '\').attr(\'name\');
    // window.alert(formfield);
    tb_show(\'\', \'media-upload.php?post_id='. $post->ID .'&TB_iframe=true\');
    return false;
  });

  // user inserts file into post. only run custom if user started process using the above process
  // window.send_to_editor(html) is how wp would normally handle the received data

  window.original_send_to_editor = window.send_to_editor;
  window.send_to_editor = function(html){
    
    if (formfield) {
      fileurl = jQuery(\'a\', "<div>"+html+"</div>").attr(\'href\');
    
      /* classes = jQuery(\'img\', html).attr(\'class\');
      fileid = classes.replace(/(.*?)wp-image-/, \'\'); 

      jQuery(\'#' . $field['id'] . '\').val(fileid);
      jQuery(\'#id_of_chosen_file\').html(fileid); */
      
      jQuery(\'#' . $field['id'] . '\').val(fileurl);
      // jQuery(\'#id_of_chosen_file\').html(fileurl);

      tb_remove();

      jQuery(\'html\').removeClass(\'Image\');

    } else {
      window.original_send_to_editor(html);
    }
  };

});
</script>
      <input type="text" style="width: 100%" readonly="readonly" name="', $field['id'], '" id="', $field['id'], '" value="', isset($meta) ? $meta : stripslashes(htmlspecialchars(( $field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                        if (!empty($field['help'])) echo "<div class='tr-metabox-help' style='clear: both;'>" . $field['help'] . "</div>";
      break;
      case "checkbox": 
        echo '<tr style="border-top:1px solid #eeeeee;">',
        '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">'. @$field['desc'].'</span></label></th>',
        '<td>';
                echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />';
                if (!empty($field['help'])) echo "<div class='tr-metabox-help' style='clear: both;'>" . $field['help'] . "</div>";
          break;
          case 'select':
            echo '<tr style="border-top:1px solid #eeeeee;">',
        '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">'. @$field['desc'].'</span></label></th>',
        '<td>';
        echo '<select  name="', $field['id'], '" id="', $field['id'], '">';
        foreach ($field['options'] as $option) {
          echo '<option';
          if(($meta!=null && $meta == $option) || ($meta==null && $option==$field['default'])) echo ' selected="selected"';
          echo ' value="'.$option.'">', $option, '</option>';
        }
        echo '</select>';
                                if (!empty($field['help'])) echo "<div class='tr-metabox-help' style='clear: both;'>" . $field['help'] . "</div>";
      break;
    }
  }
 
  echo '</table>';
}

function tradetheme_product_box_save( $post_id ) {

  if (!function_exists('get_meta_box')) return;
  
  $meta_box_tradematik=get_meta_box();

  $meta_box_tradematik['fields'][] = array(
      'name' =>  __('Item specification', 'tradematik-theme'),
      'desc' => __('Not required', 'tradematik-theme'),
      'id' => 'attr_spec',
      'type' => 'textarea',
      'std' => '',
      'help' => __('Each parameter insert in new line. After name of parameter type colon and then value of this parameter.', 'tradematik-theme')
    );
  
  // verify nonce
  if (!@wp_verify_nonce($_POST['tradematik'], basename(__FILE__))) {
    return $post_id;
  }
 
  // check autosave
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    return $post_id;
  }
 
  // check permissions
  if ('page' == $_POST['post_type']) {
    if (!current_user_can('edit_page', $post_id)) {
      return $post_id;
    }
  } elseif (!current_user_can('edit_post', $post_id)) {
    return $post_id;
  }
  
  foreach ($meta_box_tradematik['fields'] as $field) {
    $old = @get_post_meta($post_id, $field['id'], true);
    $new = @$_POST[$field['id']];
    
    if($field['id']=='attr_price') $new=(preg_replace("/,/",".",$new));
    else if($field['id']=='attr_count') $new=intval($new);
 
    if (isset($new) && $new !== $old) {
      update_post_meta($post_id, $field['id'], stripslashes(htmlspecialchars($new)));
      
    } elseif ('' == $new && $old && $new!=='0') {
      delete_post_meta($post_id, $field['id'], $old);
    }
  }
}