<?php

add_action('add_meta_boxes', 'trade_slider_metabox');

function trade_slider_metabox() {

	add_meta_box('slider-metabox', __('Show in slider', 'tradematik-theme'), 'trade_slider_metabox_inner', 'produkty' );
	add_meta_box('slider-metabox', __('Show in slider', 'tradematik-theme'), 'trade_slider_metabox_inner', 'post' );
	add_meta_box('slider-metabox', __('Show in slider', 'tradematik-theme'), 'trade_slider_metabox_inner', 'page' );

}

function trade_slider_metabox_inner($post) {
  // The actual fields for data entry
  // Use get_post_meta to retrieve an existing value from the database and use the value for the form
  $value = get_post_meta( $post->ID, 'trade_show_in_slider', true );
  $checked = '';
  if ($value == 'show') $checked = 'checked';
  echo '<label for="trade_show_in_slider">';
       _e("Show this content in slider", 'tradematik-theme' );
  echo '</label> ';
  echo '<input type="checkbox" id="trade_show_in_slider" name="trade_show_in_slider" value="show" '.$checked.' 
  		 />';
}

add_action( 'save_post', 'trade_slider_save_postdata' );

function trade_slider_save_postdata($post_id) {
  // verify if this is an auto save routine. 
  // If it is our form has not been submitted, so we dont want to do anything
  if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
      return;

  

  //if saving in a custom table, get post_ID
  // $post_ID = $post_id;
  //sanitize user input
  $mydata = sanitize_text_field( @$_POST['trade_show_in_slider'] );

  // exit($mydata);

  // Do something with $mydata 
  // either using 
  add_post_meta($post_id, 'trade_show_in_slider', $mydata, true) or
    update_post_meta($post_id, 'trade_show_in_slider', $mydata);
  // or a custom table (see Further Reading section below)
}
