<?php get_header(); ?>

    <div class="row">

        
        <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <div class="span9 pull-right">

                <?php if (have_posts()) : ?>

                <?php while (have_posts()) : the_post(); 
                    $price = false;
                    $price = get_post_meta($post->ID, 'attr_price', true);

                    $spec = get_post_meta($post->ID, 'attr_spec', true);
                    if (!empty($spec)) {
                        $spec_array = explode("\n", $spec);
                        $spec_name_value = array();

                        foreach ($spec_array as $val) {
                            $linijka_array = explode(":", $val);
                            $spec_name_value[$linijka_array[0]] = $linijka_array[1];
                        }
                    }

                    $obrazki = get_posts(array(
                        'numberposts' => 5,
                        'post_parent' => get_the_ID(),
                        'post_type' => 'attachment',
                        'post_mime_type' => 'image',
                        'order' => 'ASC',
                        'orderby' => 'menu_order ID'
                    ));

                    if (!empty($obrazki)) {

                        $obrazy = array();
                        $index = 0;
                        foreach ($obrazki as $obrazek) {

                            $obrazy[$index]['produkt'] = wp_get_attachment_image_src( $obrazek->ID, 'produkt');
                            $obrazy[$index]['produkt-thumb'] = wp_get_attachment_image_src( $obrazek->ID, 'produkt-thumb');
                            $obrazy[$index]['full'] = wp_get_attachment_image_src( $obrazek->ID, 'full');
                            $obrazy[$index]['description'] = $obrazek->post_content;

                            $index++;
                        }
                    }


                ?>

                <h1><?php the_title(); ?></h1>

                <div class="row">

                    <div class="span6">

                        <?php if (!empty($obrazy)) : ?>

                        <div class="tabbable tabs-below">                    

                        <div class="tab-content">

                        <?php foreach ($obrazy as $oid => $obraz) : ?>

                        <div class="tab-pane <?php if ($oid == 0 ) echo 'active' ?>" id="sphoto<?php echo $oid; ?>">
                            <a href="<?php echo $obraz['full'][0] ?>" class="thickbox" rel="gallery-produkty"  title="<?php echo $obraz['description'] ?>">
                                <img src="<?php echo $obraz['produkt'][0] ?>" 
                                     class="img-rounded" width="<?php echo $obraz['produkt'][1] ?>" 
                                     height="<?php echo $obraz['produkt'][2] ?>"
                                     >
                            </a>
                        </div>

                        <?php endforeach; ?>
                        
                        </div>
                        
                        <ul class="nav nav-tabs" id="myTab">

                        <?php foreach ($obrazy as $oid => $obraz) : ?>

                        <li class="<?php if ($oid == 0 ) echo 'active' ?>"><a href="#sphoto<?php echo $oid; ?>">
                            <img src="<?php echo $obraz['produkt-thumb'][0] ?>" 
                                 width="<?php echo $obraz['produkt-thumb'][1] ?>" 
                                 height="<?php echo $obraz['produkt-thumb'][2] ?>"
                                 title="<?php echo $obraz['description'] ?>">
                        </a></li>

                        <?php endforeach; ?>

                        
                        </ul>
                         
                        

                        </div>

                        <?php endif; // !empty($obrazy) ?>

                    </div>

                    <div class="span3">
                            <p class="pull-right lead"><strong><?php _e('Price', 'tradematik-theme') ?>:</strong> <?php echo $price; ?> <?php echo get_option('trade_opt_dotpay_currency'); ?></p>

                            <form class="the_trade_box_form" action="<?php echo get_permalink(get_option('trade_opt_cart_page')); ?>" method="post">
                                <input type="hidden" value="<?php the_ID(); ?>" name="trade_item_id">
                                <button type="submit" name="trade_add_to_cart" class="btn btn-success pull-right" title="<?php _e('Add to cart', 'tradematik-theme'); ?>">
                                    <i class="icon-shopping-cart icon-white"></i> <?php _e('Add to cart', 'tradematik-theme'); ?> &raquo;
                                </button> 
                            </form>

                    </div>

                </div>

                <div class="row">
                    <div class="span9">
                        <h2><?php _e('Product description', 'tradematik-theme'); ?></h2>
                        <?php the_content(); ?>

                        <?php if (!empty($spec_name_value)) : ?>

                        <h2><?php _e("Specification", 'tradematik-theme') ?></h2>

                        <dl class="dl-horizontal">
                            <?php foreach ($spec_name_value as $key => $value) : ?>
                            <dt><?php echo $key; ?></dt>
                            <dd><?php echo $value; ?></dd>
                            <?php endforeach; ?>
                            
                        </dl>

                        <?php endif; // !empty($spec_name_value) ?>

                        <div class="tabbable tabs-left">
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#tab1" data-toggle="tab"><?php _e('Buy now!', 'tradematik-theme') ?></a></li>
                            <li><a href="#tab3" data-toggle="tab"><?php _e('Reviews', 'tradematik-theme') ?></a></li>
                            <li><a href="#tab2" data-toggle="tab"><?php _e('Ask question', 'tradematik-theme') ?></a></li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <p class="lead"><strong><?php _e('Price per item', 'tradematik-theme') ?>:</strong> <?php echo $price; ?> <?php echo get_option('trade_opt_dotpay_currency'); ?></p>
                                
                                <form class="the_trade_box_form" action="<?php echo get_permalink(get_option('trade_opt_cart_page')); ?>" method="post">
                                <input type="hidden" value="<?php the_ID(); ?>" name="trade_item_id">
                                <button type="submit" name="trade_add_to_cart" class="btn btn-success btn-large" title="<?php _e('Add to cart', 'tradematik-theme'); ?>">
                                    <i class="icon-shopping-cart icon-white"></i> <?php _e('Add to cart', 'tradematik-theme'); ?>
                                </button> 
                            </form>

                            </div>

                            <div class="tab-pane" id="tab2">
                            
                                    <form class="form-horizontal" id="askQuestionForm" method="post" action="<?php the_permalink(); ?>">
                                        <legend><?php _e('Ask question', 'tradematik-theme'); ?></legend>
                                    <div id="askQuestionFormInner">
                                    <div class="control-group" id="controlInputQuestion">
                                    <label class="control-label" for="inputQuestion"><?php _e('Your question', 'tradematik-theme'); ?></label>
                                    <div class="controls">
                                    <textarea id="inputQuestion" placeholder="<?php _e('Type your question', 'tradematik-theme'); ?>" class="input-xlarge" required></textarea>
                                    </div>
                                    </div>

                                    <div class="control-group" id="controlInputEmail">
                                    <label class="control-label" for="inputEmail"><?php _e('Your email', 'tradematik-theme'); ?></label>
                                    <div class="controls">
                                    <input type="email" id="inputEmail" placeholder="<?php _e('Email', 'tradematik-theme'); ?>" class="input-xlarge" required>
                                    </div>
                                    </div>
                                    
                                    <div class="control-group">
                                    <div class="controls">

                                    <input type="hidden" name="askQuestionAboutID" value="<?php the_ID(); ?>">

                                    <input type="hidden" name="askQuestionAboutName" value="<?php the_title(); ?>">
                                    
                                    <button type="submit" class="btn"><?php _e('Ask question', 'tradematik-theme'); ?></button>
                                    </div>
                                    </div>

                                    </div>
                                    </form>

                            </div>

                            <div class="tab-pane" id="tab3">

                                    <?php comments_template('/reviews.php'); ?>

                                    

                                    <form class="form-horizontal" id="commentform" method="post" action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php">
                                        <legend><?php _e('Add your review', 'tradematik-theme'); ?></legend>
                                    <div class="control-group">
                                    <label class="control-label" for="inputCommentText"><?php _e('Content of review', 'tradematik-theme'); ?></label>
                                    <div class="controls">
                                    <textarea id="inputCommentText" name="comment" placeholder="<?php _e('What is your opinion?', 'tradematik-theme'); ?>" class="input-xlarge"></textarea>
                                    </div>
                                    </div>

                                    <div class="control-group">
                                    <label class="control-label" for="inputCommentName"><?php _e('Signature', 'tradematik-theme'); ?></label>
                                    <div class="controls">
                                    <input type="text" id="inputCommentName" name="author" placeholder="<?php _e('Name and family name', 'tradematik-theme'); ?>" class="input-xlarge">
                                    </div>
                                    </div>

                                    <div class="control-group">
                                    <label class="control-label" for="inputCommentEmail"><?php _e('Your email', 'tradematik-theme'); ?></label>
                                    <div class="controls">
                                    <input type="text" id="inputCommentEmail" name="email" placeholder="<?php _e('Email', 'tradematik-theme'); ?>" class="input-xlarge">
                                    </div>
                                    </div>
                                    
                                    <div class="control-group">
                                    <div class="controls">

                                    <input id="comment_post_ID" type="hidden" value="<?php the_ID() ?>" name="comment_post_ID">
                                    <input id="comment_parent" type="hidden" value="0" name="comment_parent">
                                    
                                    <button type="submit" class="btn"><?php _e('Add review', 'tradematik-theme'); ?></button>
                                    </div>
                                    </div>
                                    </form>

                            </div>

                        </div>
                        </div>


                    </div>
                </div>

                <?php endwhile; ?>

                <?php endif; // have_posts ?>


            </div>

        </div>

        <?php get_sidebar(); ?>

    </div>
<?php get_footer(); ?>